% The following script imports data from a dataset and plots a 2D risk plot
% Author: Nish Mohith Kurukuti
% Developed for plotting data generated for Kurukuti et al. 2024
% Risk of pedestrian collision for persons with peripheral field loss: A
% computation analysis

%% Importing data
[filename, pathname] = uigetfile('*.mat*');
load([pathname filename]);

%% Extraction and Plotting
start_pos_x = ones(length(0.6:0.02:5),length(6:-0.02:-3))';
start_pos_x = start_pos_x.*(0.6:0.02:5);
start_pos_y = ones(length(0.6:0.02:5),length(6:-0.02:-3))';
start_pos_y = start_pos_y.*(6:-0.02:-3)';

risk = zeros(length(0.6:0.02:5),length(6:-0.02:-3))';
bearing = zeros(length(0.6:0.02:5),length(6:-0.02:-3))';

indx = 1;
for st_x = 1:size(start_pos_x,2)
    for st_y = 1:size(start_pos_y,1)
        Pedestrian.InitPos = [start_pos_x(1,st_x) start_pos_y(st_y,1)];
        indx_x = find(round(Pedestrian.InitPos(1),2) == round(start_pos_x(1,:),2));
        indx_y = find(round(Pedestrian.InitPos(2),2) == round(start_pos_y(:,1),2));
        if ~isempty(indx_x) && ~isempty(indx_y)
            risk(indx_y,indx_x) = risk(indx_y,indx_x) + Data{indx}.risk/1.8;
            bearing(indx_y,indx_x) = bearing(indx_y,indx_x) + Data{indx}.bearing;
        end
        indx = indx + 1;
        status = indx/(size(start_pos_x,1)*size(start_pos_x,2))*100
    end
end

commonFontSize = 12;
colormap jet
color_list = [0 0.00253666614075333 0.00507333228150667 0.00760999842226 0.0101466645630133 0.0126833307037667 0.01521999684452 0.0177566629852733 0.0202933291260267 0.02282999526678 0.0253666614075333 0.0279033275482867 0.03043999368904 0.0329766598297933 0.0355133259705467 0.0380499921113 0.0405866582520533 0.0431233243928067 0.04565999053356 0.0481966566743133 0.0507333228150667 0.05326998895582 0.0558066550965733 0.0583433212373267 0.06087998737808 0.0634166535188333 0.0659533196595867 0.06848998580034 0.0710266519410933 0.0735633180818467 0.0760999842226 0.0786366503633533 0.0811733165041067 0.08370998264486 0.0862466487856133 0.0887833149263667 0.09131998106712 0.0938566472078733 0.0963933133486267 0.09892997948938 0.101466645630133 0.104003311770887 0.10653997791164 0.109076644052393 0.111613310193147 0.1141499763339 0.116686642474653 0.119223308615407 0.12175997475616 0.124296640896913 0.126833307037667 0.12936997317842 0.131906639319173 0.134443305459927 0.13697997160068 0.139516637741433 0.142053303882187 0.14458997002294 0.147126636163693 0.149663302304447 0.1521999684452 0.154736634585953 0.157273300726707 0.15980996686746 0.162346633008213 0.164883299148967 0.16741996528972 0.169956631430473 0.172493297571227 0.17502996371198 0.177566629852733 0.180103295993487 0.18263996213424 0.185176628274993 0.187713294415747 0.1902499605565 0.192786626697253 0.195323292838007 0.19785995897876 0.200396625119513 0.202933291260267 0.20546995740102 0.208006623541773 0.210543289682527 0.21307995582328 0.215616621964033 0.218153288104787 0.22068995424554 0.223226620386293 0.225763286527047 0.2282999526678 0.230836618808553 0.233373284949307 0.23590995109006 0.238446617230813 0.240983283371567 0.24351994951232 0.246056615653073 0.248593281793827 0.25112994793458 0.253666614075333 0.256203280216087 0.25873994635684 0.261276612497593 0.263813278638347 0.2663499447791 0.268886610919853 0.271423277060607 0.27395994320136 0.276496609342113 0.279033275482867 0.28156994162362 0.284106607764373 0.286643273905127 0.28917994004588 0.291716606186633 0.294253272327387 0.29678993846814 0.299326604608893 0.301863270749647 0.3043999368904 0.306936603031153 0.309473269171907 0.31200993531266 0.314546601453413 0.317083267594167 0.31961993373492 0.322156599875673 0.324693266016427];
contourf(start_pos_x, start_pos_y, risk,128,'LineStyle','none','Color',[0 0 0],'LevelList',color_list)
daspect([1 1 1])
hc = colorbar;
set(hc,'FontSize',commonFontSize);
caxis([0 0.3247]);
set(gca,'FontSize',commonFontSize);
xlabel('','FontSize',commonFontSize);
ylabel('','FontSize',commonFontSize);
set(gca,'layer','top'); %needed to make the tick marks show up
ylim([-3 6]);
yticks = [-3 0 3 6];
ylabs = {'-3m'; '0m'; '3m'; '6m'};
set(gca, 'YTick',yticks,'LineWidth',0.5)
set(gca,'YTickLabel',ylabs,'FontSize',commonFontSize);   %this also alters the legend font size 
xlim([0.6 5]);
xticks = [0.6 5]; 
xlabs = {'0.6' ;'5m';''}; %the tick is at 9, but labeled 10 so that 10 does not get cut off. ELI SAID DELETE 10
set(gca,'XTick',xticks,'LineWidth',0.5);
set(gca,'XTickLabel',xlabs,'FontSize',commonFontSize);   %this also alters the legend font size 
set(gca,'ticklength',3*get(gca,'ticklength'))
set(gca,'Color',[0 0 0]);  %sets backgground to white (nope. didnt work).